' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports Microsoft.VisualBasic

Public Class BlogEntry

  Private _id As Integer = -1
  Private _title As String = String.Empty
  Private _body As String = String.Empty
  Private _categoryId As Integer = -1
  Private _datePublished As DateTime = DateTime.MinValue

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Domylny konstruktor klasy BlogEntry. 
  ''' </summary>
  Public Sub New()
  End Sub

  ''' <summary>
  ''' Przeciony konstruktor klasy BlogEntry, ktry przyjmuje Identyfikator wpisu w bazie danych.
  ''' </summary>
  Public Sub New(ByVal id As Integer)
    _id = id
  End Sub

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Pobiera identyfikator wpisu.
  ''' </summary>
  Public ReadOnly Property Id() As Integer
    Get
      Return _id
    End Get
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia tytu wpisu.
  ''' </summary>
  Public Property Title() As String
    Get
      Return _title
    End Get
    Set(ByVal value As String)
      _title = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia tre wpisu.
  ''' </summary>
  Public Property Body() As String
    Get
      Return _body
    End Get
    Set(ByVal value As String)
      _body = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia identyfikator kategorii, do ktrej naley wpis.
  ''' </summary>
  Public Property CategoryId() As Integer
    Get
      Return _categoryId
    End Get
    Set(ByVal value As Integer)
      _categoryId = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia dat i czas publikacji wpisu.
  ''' </summary>
  Public Property DatePublished() As DateTime
    Get
      Return _datePublished
    End Get
    Set(ByVal value As DateTime)
      _datePublished = value
    End Set
  End Property

#End Region

End Class
